from os           import environ
from Tkinter      import Frame, Button, Tk, Label, StringVar
from tkFileDialog import askdirectory
from moveFiles    import moveFiles, copyFiles
from os           import environ, getcwd, path
from Schedule     import ScheduleEditor

class Window(Frame):
    def __init__(self,master=None):
        Frame.__init__(self, master,)
        
        self.dir_opt_src = {}
        self.dir_opt_src['parent'] = self.master
        self.source = self.dir_opt_src['initialdir'] = path.abspath("../database/media/notepads")
        self.dir_opt_src['title'] = 'Choose The Source Directory'
        self.dir_opt_des = {}
        self.dir_opt_des['parent'] = self.master
        self.dest = self.dir_opt_des['initialdir'] = environ['HOME']
        self.dir_opt_des['title'] = 'Choose The Destination Directory'
        
        #creating the frames
        infoFrame = Frame(master=self)
        self.labelFrame = Frame(master=infoFrame)
        self.buttonFrame = Frame(master=infoFrame)
        actionFrame = Frame(master=self)
        
        self.master.title('Note Importer')
        
        #creating the Widgets and packing them into frames
        #creating the buttons
        Button(self.buttonFrame,text='Source',command=self.asksrcdirectory).pack(side='top',anchor='w')
        Button(self.buttonFrame,text='Destination',command=self.askdesdirectory).pack(side='bottom',anchor='w')
        #creating the labels
        self.sourceLabel = Label(self.labelFrame,text=self.source,width=100,anchor='w')
        self.sourceLabel.pack(side='top',anchor='w')
        self.destLabel = Label(self.labelFrame,text=self.dest,width=100,anchor='w')
        self.destLabel.pack(side='bottom',anchor='w')
        
        Button(actionFrame,text='Move Files',command=self.move).pack(side='left')
        Button(actionFrame,text='Copy Files',command=self.copy).pack(side='right')
        #packing the frames
        self.labelFrame.pack(padx='10',side='right')
        self.buttonFrame.pack(padx='10',side='left')
        infoFrame.pack(side='top')
        actionFrame.pack(padx='10',pady='10',side='bottom')
        
    def asksrcdirectory(self):
        self.source = askdirectory(**self.dir_opt_src)
        self.remakeLabels()
    
    def askdesdirectory(self):
        self.dest = askdirectory(**self.dir_opt_des)
        self.remakeLabels()
    
    def remakeLabels(self):
        self.sourceLabel.destroy()
        self.sourceLabel = Label(self.labelFrame,text=self.source,width=100,anchor='w')
        self.sourceLabel.pack(side='top',anchor='w')
        self.destLabel.destroy()
        self.destLabel = Label(self.labelFrame,text=self.dest,width=100,anchor='w')
        self.destLabel.pack(side='bottom',anchor='w')
    
    def sourcedir(self):
        return self.source
    
    def destdir(self):
        return self.dest
    
    def move(self):
        moveFiles(self.source,self.dest)
        
    def copy(self):
        copyFiles(self.source,self.dest)

def main():
    root = Tk()
    Window(root).pack()
    ScheduleEditor(root).pack()
    root.mainloop()
    
if __name__=='__main__':
    main()